IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_IMP_NEGADO_ALCADA]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[QT_PROD] [money] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[HIST] [varchar](120) NOT NULL,
	[TP_IMP] [int] NOT NULL,
	[TP_EST] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU_NEGOU] [int] NOT NULL,
	[DT_CAD_NEGACAO] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PROD_IMP_NEGADO_ALCADA] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]


ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_QT_PROD]  DEFAULT ((0)) FOR [QT_PROD]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_HIST]  DEFAULT ('') FOR [HIST]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_TP_IMP]  DEFAULT ((0)) FOR [TP_IMP]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_TP_EST]  DEFAULT ((0)) FOR [TP_EST]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_CD_USU_NEGOU]  DEFAULT ((0)) FOR [CD_USU_NEGOU]

ALTER TABLE [dbo].[EST_PROD_IMP_NEGADO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_NEGADO_ALCADA_DT_CAD_NEGACAO]  DEFAULT (getdate()) FOR [DT_CAD_NEGACAO]
end

